/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 *
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *
 *-------------------------------------------------------------------*/
/* Caspian is an API developed chipset based in the AMD Irongate but adding
 * dual-processor support and LDT */

/* There was some suggestion that the PCI device IDs used by Goby could be 
 * something other than 0 and 1 (24,25?).  If so, override these definitions
 * in the platform-specific include file.
 */

#ifndef GOBY0_DEV		/* override for PCI device ID */
#define GOBY0_DEV 0
#endif

#ifndef GOBY1_DEV		/* override for PCI device ID */
#define GOBY1_DEV 1
#endif

/*------------------------------------------------------------------------*/
/* Goby PCI configuration space CSRs */

#define GOBY0_VENDOR	0x00
#define GOBY0_DEVICE	0x02
#define GOBY0_CMD	0x04
#define GOBY0_STATUS	0x06
#define GOBY0_REV	0x08
#define GOBY0_PROG_IF	0x09
#define GOBY0_SUBCLASS	0x0A
#define GOBY0_BASECLASS	0x0B

#define GOBY0_LATENCY	0x0D
#define GOBY0_HTYPE	0x0E

#define GOBY0_BAR0	0x10
#define GOBY0_BAR1	0x14
#define GOBY0_BAR2	0x18
#define GOBY0_BAR3	0x1C

#define GOBY0_VMSIZE	GOBY0_BAR0	/* GART PCI memory requirement */
#define GOBY0_GART	GOBY0_BAR1	/* GART control registers */
#define GOBY0_PM2	GOBY0_BAR2	/* PM2 I/O */
#define GOBY0_IRQ	GOBY0_BAR3	/* Interrupt registers */



#define GOBY0_DIMM0	0x40		/* DIMM base address registers */
#define GOBY0_DIMM1	0x42
#define GOBY0_DIMM2	0x44
#define GOBY0_DIMM3	0x46
#define GOBY0_DIMM4	0x48
#define GOBY0_DIMM5	0x4A
#define GOBY0_DIMM6	0x4C
#define GOBY0_DIMM7	0x4E

#define GOBY0_SDRAM_MAP	0x50
#define GOBY0_TIMING	0x54
#define GOBY0_ECC	0x58		/* ECC status and DRAM mode/status */
#define GOBY0_MODE	0x5C		/* SDRAM mode and ECC mask */
#define GOBY0_BIU0	0x60		/* BIU0 control and status */
#define GOBY0_BIU0_SIP	0x64		/* BIU0 SIP (serial init packet) */
#define GOBY0_BIU1	0x68		/* BIU1 control and status */
#define GOBY0_BIU1_SIP	0x6C		/* BIU1 SIP (serial init packet) */

#define GOBY0_MRO	0x70

#define GOBY0_WHAMI	0x80		/* WHAMI, boot cpu, cpus present */
#define GOBY0_PCIARB	0x84
#define GOBY0_CFGSTAT	0x88
#define GOBY0_PCIERR	0x8C
#define GOBY0_DVMA0	0xA0
#define GOBY0_DVMA1	0xA4

#define GOBY0_DEBUG	0xAC
#define GOBY0_GART_ADDR	0xAE

#define GOBY0_GARTMODE	0xB0
#define GOBY0_FATALERR	0xB4
#define GOBY0_NFATALERR	0xB8

#define GOBY0_SCRATCH0	0xC0
#define GOBY0_SCRATCH1	0xC4
#define GOBY0_SCRATCH2	0xC8
#define GOBY0_SCRATCH3	0xCC
#define GOBY0_SCRATCH4	0xD0
#define GOBY0_SCRATCH5	0xD4
#define GOBY0_SCRATCH6	0xD8
#define GOBY0_SCRATCH7	0xDC

/*------------------------------------------------------------------------*/
/* Goby PCI-memory-mapped IRQ CSRs */
/* These CSRs are in PCI memory space indexed from base address held in BAR3 */

#define GOBY_IRQ_IRR	0x00	/* Interrupt requests received */
#define GOBY_IRQ_ITM	0x20	/* Interrupt trigger mode */
#define GOBY_IRQ_ILR	0x40	/* Interrupt line routing */
#define GOBY_IRQ_LIR	0xA0	/* Local interrupt routing */

#define   LIR_TIMER_EN	(1UL<<63)	/* periodic timer enable */
#define   LIR_TMODE	(1UL<<57) /* periodic timer mode (fixed at 0) */
#define   LIR_TMODE_EDG	(0UL<<57) /* periodic timer mode */
#define   LIR_TMODE_LVL	(1UL<<57) /* periodic timer mode */
#define   LIR_TIRQ_S	48	/* periodic timer IRQ vector (fixed 33) */
#define   LIR_TIRQ_M	(0xFFUL<<LIR_TIRQ_S)

#define   LIR_NMI_EN	(1UL<<47)	/* NMI is enabled if this bit is set */
#define	  LIR_NMODE	(1UL<<57)	/* NMI interrupt mode (fixed at 0) */
#define	  LIR_NMODE_EDG	(0UL<<57)	/* NMI interrupt mode */
#define	  LIR_NMODE_LVL	(1UL<<57)	/* NMI interrupt mode */
#define	  LIR_NIRQ_S	32		/* NMI IRQ vector (fixed at 32) */
#define   LIR_NIRQ_M	(0xFFUL<<LIR_NIRQ_S)

#define   LIR_SMI_EN	(1UL<<31)	/* SMI is enabled if this bit is set */
#define	  LIR_SMODE	(1UL<<25)	/* SMI interrupt mode (fixed at 0) */
#define	  LIR_SMODE_EDG	(0UL<<25)	/* SMI interrupt mode */
#define	  LIR_SMODE_LVL	(1UL<<25)	/* SMI interrupt mode */
#define	  LIR_SIRQ_S	16		/* SMI IRQ vector (fixed at 31) */
#define   LIR_SIRQ_M	(0xFFUL<<LIR_SIRQ_S)

#define   LIR_LOCL_EN	(1UL<<15) /* Local IO int is enabled if this bit is set */
#define	  LIR_LMODE	(1UL<<9)	/* Local interrupt mode (fixed at 0) */
#define	  LIR_LMODE_EDG	(0UL<<9)	/* Local interrupt mode */
#define	  LIR_LMODE_LVL	(1UL<<9)	/* Local interrupt mode */
#define	  LIR_LIRQ_S	0		/* Local IRQ vector (fixed at 30) */
#define   LIR_LIRQ_M	(0xFFUL<<LIR_LIRQ_S)

#define GOBY_IRQ_TIMER	33
#define GOBY_IRQ_NMI	32
#define GOBY_IRQ_SMI	31
#define GOBY_IRQ_LOCAL	30

#define GOBY_IRQ_EIR	0xA8

/* Interrupt CSRs relating to a particular system port (but globally visible) */

#define I_PORT0 	0x100	/* Offset for system port 0 CSRs */
#define I_PORT1 	0x200	/* Offset for system port 1 CSRs */

#define I_IRP		0x00	/* Interrupt requests pending */
#define I_ISR		0x20	/* Interrupt service requests */
#define I_IEM		0x40	/* Interrupt enables mask */
#define I_EOI		0x60	/* End of interrupt */

#define I_SIR		0x80	/* Send interrupt request */
#define		SIR_VEC_S	0		/* Interrupt source # */
#define		SIR_VEC_M	(0xFF<<SIR_VEC_S)
#define		SIR_DEST_S	8		/* destination ID */
#define		SIR_DEST_M	(0xFF<<SIR_DEST_S)
#define		SIR_DM_S	16		/* Destination mode */
#define		SIR_DM_LOG	(1UL<<SIR_DM_S)
#define		SIR_DM_PHYS	(0UL<<SIR_DM_S)
#define		SIR_TRIG_S	18		/* Trigger mode */
#define		SIR_TRIG_EDG	(0UL<<SIR_TRIG_S)
#define		SIR_TRIG_LVL	(1UL<<SIR_TRIG_S)
#define		SIR_ACTIVATE	(1UL<<19)	/* activate! */

#define I_II		0x88	/* Interrupt identification */
#define		II_PHYS_S	0		/* physical ID - port number */
#define		II_PHYS_M	(0xFF<<II_PHYS_S)
#define		II_LOG_S	8		/* logical ID - SW notion */
#define		II_LOG_M	(0xFF<<II_LOG_S)
#define		II_LOGM_S	16		/* logical ID mask - ?? */
#define		II_LOGM_M	(0xFF<<II_LOGM_S)

#define I_ITP		0x90	/* Interrupt task priority */

#define GOBY_IRQ_IRP0	(I_PORT0 + I_IRP)
#define GOBY_IRQ_ISR0	(I_PORT0 + I_ISR)
#define GOBY_IRQ_IEM0	(I_PORT0 + I_IEM)
#define GOBY_IRQ_EOI0	(I_PORT0 + I_EOI)
#define GOBY_IRQ_SIR0	(I_PORT0 + I_SIR)
#define GOBY_IRQ_II0	(I_PORT0 + I_II)
#define GOBY_IRQ_ITP0	(I_PORT0 + I_ITP)

#define GOBY_IRQ_IRP1	(I_PORT1 + I_IRP)
#define GOBY_IRQ_ISR1	(I_PORT1 + I_ISR)
#define GOBY_IRQ_IEM1	(I_PORT1 + I_IEM)
#define GOBY_IRQ_EOI1	(I_PORT1 + I_EOI)
#define GOBY_IRQ_SIR1	(I_PORT1 + I_SIR)
#define GOBY_IRQ_II1	(I_PORT1 + I_II)
#define GOBY_IRQ_ITP1	(I_PORT1 + I_ITP)


/* Send Interrupt request register definitions */
#define   SIR_ACT	(1<<19)	/* set to 1 to Activate the send (HW clears) */
#define	  SIR_TRIG	(1<<18) /* 0=edge, 1=level */
#define	    SIR_TRIG_ED	(0<<18) /* 0=edge, 1=level */
#define	    SIR_TRIG_LV	(1<<18) /* 0=edge, 1=level */
#define   SIR_DESTMODE  (1<<16) /* The destination mode of the interrupt (??) */
#define   SIR_DEST_S	8	/* Destination ID */
#define	  SIR_DEST_M	(0xFF<<SIR_DEST_S)
#define   SIR_IRQ_S	0	/* Interrupt vector to be delivered */
#define	  SIR_IRQ_M	(0xFF<<SIR_IRQ_S)


/*------------------------------------------------------------------------*/
/* Specific access routines */

void goby_revstr( char * );	/* return silicon revision as a string */

/* Dump the IO-space mapped interrupt CSRs */
void goby_irq_dump( void );

/* Return the base address of the interrupt CSRs */
unsigned goby_irq_base( void );

/* Set a bit in the interrupt routings to make a map between goby and alpha */
void goby_map_irq( const unsigned goby_irq, const unsigned alpha_irq );

/* Unmask (enable) a particular goby irq on a particular processor */
void goby_enable_irq( const unsigned goby_irq, const unsigned cpuid );

/* Send a given interrupt to a given processor */
void goby_send_irq( const unsigned goby_irq, const unsigned cpuid );

